/**----------------------------------------------/
 * Lens FX Shader File 
 * File Author : Wilham A. Putro ( AeroFX  )
 * File Version : 1.4.534.08 ( May 2015 )
 * Copyright (c) 2014 - 2015 Wilham Anggowo Putro
 *-----------------------------------------------/
 * ENBSeries Main FX file
 * Visit http://enbdev.com for Updates
 * Copyright (c) 2007 - 2014 Boris Vorontsov
 *----------------------------------------------*/

/**----------------------------------------------/
 * Enable Effects 
 *----------------------------------------------*/
#define BLOOM_HAZE				1
/**----------------------------------------------/
 * Effects Parameter
 *----------------------------------------------*/

/**----------------------------------------------/
 * In Game GUI Parameter
 *----------------------------------------------*/
	float BloomThreshold <
		string UIName="Bloom Haze Threshold";
		string UIWidget="Spinner";
		float UIMin=0.0;
		float UIMax=100.0;
		float UIStep=0.1;
	> = {0.20};
	
	float BloomIntensity <
		string UIName="Bloom Haze Intensity";
		string UIWidget="Spinner";
		float UIMin=0.0;
		float UIMax=100.0;
		float UIStep=0.1;
	> = {10.0};
	
/*-----------------------------------------------------/
 * !!! EXTERNAL PARAMENTERS, DO NOT MODIFY IT !!!
 *     !!! EXCEPT IF YOU KNOW WHAT YOU DO !!!
 *----------------------------------------------------*/
float4	tempF1; 				//0,1,2,3
float4	tempF2; 				//5,6,7,8
float4	tempF3; 				//9,0
float4	ScreenSize;				//x=Width, y=1/Width, z=ScreenScaleY, w=1/ScreenScaleY
float	ENightDayFactor;		//changes in range 0..1, 0 means that night time, 1 - day time
float4	Timer;					//x=generic timer in range 0..1, period of 16777216 ms (4.6 hours), w=frame time elapsed (in seconds)
float4	TempParameters; 		//additional info for computations
float4	LensParameters;			//x=reflection intensity, y=reflection power, z=dirt intensity, w=dirt power
float	FieldOfView;			//fov in degrees


/*---------------------/
 *   	TEXTURES   
 *--------------------*/

texture2D texColor;
texture2D texMask;
texture2D texBloom1;
texture2D texBloom2;
texture2D texBloom3;
texture2D texBloom4;
texture2D texBloom5;
texture2D texBloom6;
texture2D texBloom7;
texture2D texBloom8;


/*-----------------------/
 *		SAMPLERS
 *----------------------*/
 
sampler2D SamplerColor = sampler_state
{
	Texture   = <texColor>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerMask = sampler_state
{
	Texture   = <texMask>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom1 = sampler_state
{
	Texture   = <texBloom1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom2 = sampler_state
{
	Texture   = <texBloom2>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom3 = sampler_state
{
	Texture   = <texBloom3>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom4 = sampler_state
{
	Texture   = <texBloom4>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom5 = sampler_state
{
	Texture   = <texBloom5>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom6 = sampler_state
{
	Texture   = <texBloom6>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom7 = sampler_state
{
	Texture   = <texBloom7>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom8 = sampler_state
{
	Texture   = <texBloom8>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};


/*-----------------------/
 * 	  STRUCTURES
 *----------------------*/
 
struct VS_OUTPUT_POST
{
	float4 vpos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};
struct VS_INPUT_POST
{
	float3 pos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};


/*---------------------------/
 * 		VERTEX SHADER
 *--------------------------*/
 
 VS_OUTPUT_POST VS_Draw(VS_INPUT_POST IN)
{
	VS_OUTPUT_POST OUT;

	OUT.vpos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);

	OUT.txcoord0.xy=IN.txcoord0.xy+TempParameters.xy;

	return OUT;
}


/*--------------------------/
 *   SHADER PASSES
 *-------------------------*/



/*-------------------------/
 *	  PIXEL SHADERS
 *------------------------*/

float4	PS_Draw(VS_OUTPUT_POST In) : COLOR
{
	float4	res=0.0;

	float2	coord;
	// Shape parameters - deepness, curvature and inverse size.
	const float3 offset[10]=
	{
		
		float3(-1.0, 15.1, 0.2),
		float3(-5.2, 46.4, 1.2),
		float3(-5.6, 7.2, 2.2),
		float3(-3.0, 27.1, 3.2),
		float3(1.0, 82.1, 6.2),
		float3(5.2, 2.0, 8.2),
		float3(8.3, 56.0, 10.2),
		float3(13.3, 3.0, 80.2),
		float3(16.0, 54.3, 90.2),
		float3(20.0, 1.3, 1.2)
	};
	
	// Color filter per reflection.
	const float3 factors[10]=
	{
		float3(0.5, 0.2, 1.9),
		float3(1.0, 0.5, 0.0),
		float3(0.5, 0.2, 0.9),
		float3(0.2, 0.3, 0.5),
		float3(0.9, 0.3, 0.5),
		float3(0.5, 0.7, 0.3),
		float3(0.3, 0.5, 0.7),
		float3(1.2, 0.2, 1.0),
		float3(0.6, 0.4, 1.1),
		float3(0.2, 1.2, 1.0)
	};

	// Do the lens sampling for 8 flares.
	for (int i=0; i<10; i++)
	{	
		// Sample position praparation.
		float2	distfact=(In.txcoord0.xy-0.5);
		coord.xy=offset[i].x*distfact;
		coord.xy*=pow(2.0*length(float2(distfact.x*ScreenSize.z,distfact.y)), offset[i].y);
		coord.xy*=offset[i].z;
		coord.xy=0.5-coord.xy;
		
		// Sampling the color from the bloom textures.
		float3	templens=tex2D(SamplerBloom2, coord.xy);
		templens=templens*factors[i];
		distfact=(coord.xy-0.5);
		distfact*=2.0;
		templens*=saturate(1.0-dot(distfact,distfact));
		
		// Final adjustment of flare color.
		float	maxlens=max(templens.x, max(templens.y, templens.z));
		float	tempnor=(maxlens/(1.0+maxlens));
		tempnor=pow(tempnor, LensParameters.y);
		templens.xyz*=tempnor;

		// Accumulation of the result.
		res.xyz+=templens;
	}
	res.xyz*=0.25*LensParameters.x;
	
	
	#if ( BLOOM_HAZE == 1 )
	float3 xblens = tex2D(SamplerBloom6, In.txcoord0.xy);
	float maxlens = max(xblens.x, max(xblens.y, xblens.z));
	float tempnor = (maxlens / (1.0 + maxlens));
	float4 mask = tex2D(SamplerMask, In.txcoord0.xy);
	
	tempnor = pow(tempnor, BloomThreshold);
	xblens.xyz *= tempnor * BloomIntensity;
	
	res.xyz += mask.xyz * xblens.xyz;
	res.w = 1.0;
	#endif
	
	return res;
}


//blurring may required when quality of blurring is too bad for bilinear filtering on screen
float4	PS_LensPostPass(VS_OUTPUT_POST In) : COLOR
{
	float4	res=0.0;

	res=tex2D(SamplerColor, In.txcoord0.xy);
	res.xyz=min(res.xyz, 32768.0);
	res.xyz=max(res.xyz, 0.0);

	return res;
}




/**-------------------------------------------/
 * Technique
 *-------------------------------------------*/
 
 
technique Draw
{
    pass p0
    {
	VertexShader = compile vs_3_0 VS_Draw();
	PixelShader  = compile ps_3_0 PS_Draw();

	ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
	CullMode=NONE;
	AlphaBlendEnable=FALSE;
	AlphaTestEnable=FALSE;
	SeparateAlphaBlendEnable=FALSE;
	SRGBWriteEnable=FALSE;
	}	
}



technique LensPostPass
{
    pass p0
    {
	VertexShader = compile vs_3_0 VS_Draw();
	PixelShader  = compile ps_3_0 PS_LensPostPass();

	AlphaBlendEnable=TRUE;
	SrcBlend=ONE;
	DestBlend=ONE;
	ColorWriteEnable=RED|GREEN|BLUE;
	CullMode=NONE;
	AlphaTestEnable=FALSE;
	SeparateAlphaBlendEnable=FALSE;
	SRGBWriteEnable=FALSE;
	}
}